<?php

namespace App\Controllers;

use App\Models\InmuebleModel;
use App\Models\ConfiguracionModel;

class Home extends BaseController
{
    protected $inmuebleModel;
    protected $configuracionModel;

    public function __construct()
    {
        $this->inmuebleModel = new InmuebleModel();
        $this->configuracionModel = new ConfiguracionModel();
        helper('inmueble');
    }

    public function index()
    {
        // Obtener parámetros de paginación
        $page = $this->request->getGet('page') ?? 1;
        $perPage = 10;
        $offset = ($page - 1) * $perPage;

        // Obtener inmuebles habilitados
        $inmuebles = $this->inmuebleModel->getInmueblesHabilitados($perPage, $offset);
        $totalInmuebles = $this->inmuebleModel->countInmueblesHabilitados();

        // Calcular paginación
        $totalPages = ceil($totalInmuebles / $perPage);
        $pagination = $this->generatePagination($page, $totalPages);

        // Obtener configuración
        $textoConfiguracion = $this->configuracionModel->getTextoConfiguracion(1);

        // Datos para la vista
        $data = [
            'title' => 'Inmobiliaria Huánuco',
            'inmuebles' => $inmuebles,
            'pagination' => $pagination,
            'currentPage' => $page,
            'totalPages' => $totalPages,
            'textoConfiguracion' => $textoConfiguracion,
            'lang' => $this->request->getGet('lang') ?? 'esp'
        ];

        return view('home/index', $data);
    }

    /**
     * Generar HTML de paginación
     */
    private function generatePagination($currentPage, $totalPages)
    {
        if ($totalPages <= 1) {
            return '';
        }

        $pagination = '<div class="horizontal_scroller">';
        $pagination .= '<div style="font-size:12px; text-align:center;">';
        $pagination .= '<b>';

        // Botón anterior
        if ($currentPage > 1) {
            $prevPage = $currentPage - 1;
            $pagination .= '<a href="?page=' . $prevPage . '" style="text-decoration:none; margin-right:10px;">&laquo; Anterior</a>';
        }

        // Números de página
        $start = max(1, $currentPage - 2);
        $end = min($totalPages, $currentPage + 2);

        for ($i = $start; $i <= $end; $i++) {
            if ($i == $currentPage) {
                $pagination .= '<span style="background-color:#22B2A8; color:white; padding:5px 10px; margin:0 2px;">' . $i . '</span>';
            } else {
                $pagination .= '<a href="?page=' . $i . '" style="text-decoration:none; padding:5px 10px; margin:0 2px; background-color:#f0f0f0;">' . $i . '</a>';
            }
        }

        // Botón siguiente
        if ($currentPage < $totalPages) {
            $nextPage = $currentPage + 1;
            $pagination .= '<a href="?page=' . $nextPage . '" style="text-decoration:none; margin-left:10px;">Siguiente &raquo;</a>';
        }

        $pagination .= '</b>';
        $pagination .= '</div>';
        $pagination .= '</div>';

        return $pagination;
    }

    /**
     * Función para cortar palabras (helper)
     */
    public function cortarPalabra($texto, $cantidadPalabras)
    {
        $palabras = explode(" ", $texto);
        $resultado = '';
        
        for ($i = 0; $i <= $cantidadPalabras && $i < count($palabras); $i++) {
            $resultado .= $palabras[$i] . " ";
        }
        
        if (count($palabras) > $cantidadPalabras) {
            $resultado .= "...";
        }
        
        return $resultado;
    }
}