<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<table width="1120" border="0" cellspacing="0" cellpadding="0" align="center">
  <tr>
    <td width="1%" class="tdTop_Left">&nbsp;&nbsp;</td>
    <td width="20%" valign="top" bgcolor="#FFFFFF">
      <!-- Izquierda -->
      <?= $this->include('layouts/leftBody') ?>
    </td>
    
    <!-- Centro -->
    <td width="60%" valign="top" style="background-color:#EEE">
      <?= $this->include('layouts/menu') ?>
      
      <div class="txtBody">
        <div align="center" class="txtBody_titulos">
          <?= ($lang == 'esp' || !$lang) ? 'Bienvenidos al Portal de Inmobiliaria Huánuco' : 'Welcome to Real Estate Portal in Huanuco' ?>
        </div>

        <p>
          <?php if ($lang == 'esp' || !$lang): ?>
            Somos un equipo de personas comprometidas en el desarrollo inmobiliario, que trabaja para que usted pueda encontrar el inmueble soñado. <br />
            <br />
            Contamos con amplia experiencia que ponemos a su disposición, así como nuestros servicios de Asesoría Jurídica, Tasación de Inmueble, Saneamiento de Predio, Independización, entre otros relacionados con el rubro.
          <?php else: ?>
            We are a team of people involved in real estate development, working for you to find the ideal property.
            <br /><br />
            We have extensive experience that we offer, and our legal advice, Property Valuation, Sanitation Predio, divestiture, among other related field.
          <?php endif; ?>
        </p>
        <br />
      </div>
    </td>

    <td width="20%" valign="top" style="background-color:#EEE">
      <!-- Derecha -->
      <?= $this->include('layouts/rightBody') ?>
    </td>
    <td width="6" class="tdTop_Right">&nbsp;&nbsp;</td>
  </tr>
  
  <tr>
    <td class="tdTop_Left"></td>
    <td colspan="3" valign="top" style="background-color:#EEE" class="txtBody">
      <!-- Listado de Inmuebles -->
      <table width="100%" height="257" border="0" align="center" cellpadding="0" cellspacing="9" class="bodyTable">
        <?php 
        $band = 1;
        foreach ($inmuebles as $inmueble): 
          $destacado = $inmueble['destacado'];
          $colorT = ($destacado == 1) ? 'FFC' : 'FFFFFF';
        ?>
          <?php if ($band == 1): ?>
            <tr>
          <?php endif; ?>
          
          <td width="50%" height="237" align="center" valign="top">
            <div>
              <table height="221" border="0" cellpadding="0" cellspacing="0" class="table table-condensed" style="margin-bottom:20px; width: 95%;">
                <tr style="border: solid 1px #767779">
                  <td height="26" colspan="2" bgcolor="#22B2A8" style="color: #000000; border-top:solid 1px #767779; font-weight: bold;">
                    &nbsp;&nbsp;<strong>&nbsp;ID: <?= $inmueble['ID'] ?> - <?= strtoupper($inmueble['dep']) ?>, <?= strtoupper($inmueble['pro']) ?>, <?= strtoupper($inmueble['dis']) ?></strong>
                  </td>
                </tr>
                
                <tr style="border: solid 1px #767779">
                  <td width="35%" height="153" align="center" bgcolor="#FFFFFF" <?= ($destacado == 1) ? 'style="background-color:#FFFFCC"' : '' ?>>
                    <?php
                    $idInm = (string) $inmueble['ID'];
                    $imageWebPath = "/admin/inmuebles/{$idInm}/{$idInm}-1.jpg";
                    $imageFsPath  = rtrim($_SERVER['DOCUMENT_ROOT'] ?? '', '/') . $imageWebPath;
                    $hasImage = is_file($imageFsPath);
                    ?>
                    <?php if ($hasImage): ?>
                      <a class="zoom" href="<?= $imageWebPath ?>">
                        <img class="fancybox-ie_zoo img-rounded" src="<?= $imageWebPath ?>" width="186" height="139" />
                      </a>
                    <?php else: ?>
                      <img class="fancybox-ie_zoo img-rounded" src="<?= base_url('assets/images/default.jpg') ?>" width="186" height="139" />
                    <?php endif; ?>
                  </td>
                  
                  <td width="64%" valign="top" bgcolor="#FFFFFF" <?= ($destacado == 1) ? 'style="background-color:#FFFFCC"' : '' ?>>
                    <br />
                    <?= cortarPalabra(stripslashes($inmueble['descripcion']), 41) ?>
                    <br />
                  </td>
                </tr>
                
                <tr style="border: solid 1px #767779">
                  <td height="42" align="center" bgcolor="#FFFFFF" <?= ($destacado == 1) ? 'style="background-color:#FFFFCC"' : '' ?>>
                    &nbsp;&nbsp;
                    <?php if ($hasImage): ?>
                      <a class="zoom" href="<?= $imageWebPath ?>">
                        <img border="0px" src="<?= base_url('assets/images/boton_lupa.png') ?>" width="26" height="26" />
                      </a>
                    <?php endif; ?>
                    
                    &nbsp;&nbsp;&nbsp; 
                    <a target="_blank" href="https://www.facebook.com/castrogram/">
                      <img border="0px" src="<?= base_url('assets/images/face.png') ?>" alt="" width="26" height="26" />
                    </a>
                    &nbsp;&nbsp;&nbsp;
                    <img src="<?= base_url('assets/images/impresora.png') ?>" alt="" width="26" height="26" onclick="abrir_ventana('<?= $inmueble['ID'] ?>')" style="cursor:pointer"/>
                    &nbsp;&nbsp;&nbsp;
                    
                    <a href="javascript:void(0);" class="whatsapp-link" data-inmueble="<?= $inmueble['ID'] ?>" data-ubigeo="<?= strtoupper($inmueble['dep']) ?>, <?= strtoupper($inmueble['pro']) ?>, <?= strtoupper($inmueble['dis']) ?>">
                      <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp" class="whatsapp-logo">
                    </a>
                  </td>
                  
                  <td bgcolor="#FFFFFF" <?= ($destacado == 1) ? 'style="background-color:#FFFFCC"' : '' ?>>
                    <div align="center">
                      <input type="submit" name="button3" id="button3" style="background-color: #FBCE33; font-weight: bold; border: solid 1px #9E8021;" value="Detalles" class="btn" onclick="verInmueble('<?= $inmueble['ID'] ?>')"/>
                    </div>
                  </td>
                </tr>
              </table>
            </div>
          </td>
          
          <?php
          if ($band != 1) {
            echo "</tr>";
            $band = 1;
          } else {
            $band++;
          }
          ?>
        <?php endforeach; ?>
      </table>
      
      <!-- Paginación -->
      <?= $pagination ?>
    </td>
    <td class="tdTop_Right"></td>
  </tr>
  
  <tr>
    <td class="tdTop_Left" height="3"> </td>
    <td bgcolor="#FFFFFF"> </td>
    <td bgcolor="#FFFFFF"> </td>
    <td bgcolor="#FFFFFF"> </td>
    <td class="tdTop_Right"> </td>
  </tr>
</table>

<?= $this->endSection() ?>
